import sys
import logging
sys.path = ['C:/Users/contestant/OSEHRA/Dashboards/OSEHRA-Automated-Testing/Python'] + sys.path
logging.getLogger('suds.client').setLevel(logging.CRITICAL)

##from OSEHRAHelper import PROMPT
##from ConnectToVista import ConnectToVista
##from AddOneInstitution import AddOneInstitution
##from AddHCSDivision import AddHCSDivision
##from AddOneDivision import AddOneDivision, AddOneDivisionP
##from AddOneServiceSection import AddOneServiceSection
##from AddOneAppointmentType import AddOneAppointmentType
##from AddOneHoliday import AddOneHoliday
##from AddOneDoctor import AddOneDoctor
##from AddDoctors import GoToUserManagementMenu, GoToPrompt
##from ReplaceDatabase import ReplaceDatabase
from time import sleep
from suds.client import Client
import copy
import datetime

from pytz import timezone
from pytz import common_timezones
import pytz
import time
from ReplaceDatabase import ReplaceDatabase

if len(sys.argv) > 1:
	if sys.argv[1] == '-verbose':
		logdetail = 1
	else:
		logdetail = 0
else:
	logdetail = 0

url = 'http://127.0.0.1/WCFService/Service1.svc?wsdl'
client = Client(url, timeout=18000)

state = 'GEORGIA'
state_short = 'GA'
domain = 'GA.VA.GOV'
facility1_site_id = '556'
facility2_abbr = 'GVARMC'
facility3_abbr = 'GVAOPC'
patient_ssn = '100000006'
patient2_ssn = '100000007'
patient3_ssn = '100000008'
patient4_ssn = '300000006'

facility1 = state_short + ' VA HEALTH CARE SYSTEM'
facility2 = state_short + ' VA REGIONAL MEDICAL CENTER'
facility2_site_id = facility1_site_id + 'MC'
facility3 = state_short + ' VA OUTPATIENT CLINIC'
facility3_site_id = facility1_site_id + 'OC'

print 'initializing vista and sql db...'
print 'plesae wait...'
client.service.RestoreDBToSnapShot("SchedulingUseCase4Baseline")
ReplaceDatabase("C:/DBBackups/vista/usecase4/cache.dat")
sleep(60)

sleep(5)
print 'setp 1'
print '\tenter patient info'
patients = client.service.SearchPatients(facility1_site_id,patient_ssn)
patient1 = client.service.GetPatient(patients[0])

print 'step 2'
print '\tverify deographics'
#print patient1

facilities = client.service.GetFacilities(client.service.GetFromVistaSiteId(facility1_site_id).Id)
for p in facilities.Facility:
	if p.Name == facility2:
		facility2_id = copy.copy(p.Id)
		break;

for p in facilities.Facility:
	if p.Name == facility3:
		facility3_id = copy.copy(p.Id)
		break;

sections = client.service.GetSections(facility2_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section1 = copy.deepcopy(p)
		break;

resources = client.service.GetAllResources(section1.Id)
for p in resources.Resource:
	if p.Name == 'case 2 step 8 provider,one':
		resource1 = copy.deepcopy(p)
		break;

sections = client.service.GetSections(facility3_id)
for p in sections.Section:
	if p.Name == 'PRIMARY CARE':
		section2 = copy.deepcopy(p)
		break;

resources = client.service.GetAllResources(section2.Id)
for p in resources.Resource:
	if p.Name == 'case2 step 2 provider':
		resource2 = copy.deepcopy(p)
		break;

schPolicies = client.factory.create('ns0:ArrayOfSchedulingPolicy')
schPolicy = client.factory.create('ns0:SchedulingPolicy')
schPolicy.DayOfWeek = '1'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
schPolicies.SchedulingPolicy = schPolicy
resource2.SchedulingPolicies = schPolicies
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

slots = client.factory.create('ns0:ArrayOfSlot')
slot = client.factory.create('ns0:Slot')
slot.Time = 'PT15H'
slot.Length = 30
slot.Capacity = 1
slot.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot)

slot2 = client.factory.create('ns0:Slot')
slot2.Time = 'PT15H30M'
slot2.Length = 30
slot2.Capacity = 1
slot2.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot2)

slot3 = client.factory.create('ns0:Slot')
slot3.Time = 'PT16H'
slot3.Length = 30
slot3.Capacity = 1
slot3.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot3)

slot4 = client.factory.create('ns0:Slot')
slot4.Time = 'PT16H30M'
slot4.Length = 30
slot4.Capacity = 1
slot4.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot4)

slot5 = client.factory.create('ns0:Slot')
slot5.Time = 'PT17H'
slot5.Length = 30
slot5.Capacity = 1
slot5.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot5)

slot6 = client.factory.create('ns0:Slot')
slot6.Time = 'PT17H30M'
slot6.Length = 30
slot6.Capacity = 1
slot6.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot6)

slot7 = client.factory.create('ns0:Slot')
slot7.Time = 'PT18H'
slot7.Length = 30
slot7.Capacity = 5
slot7.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot7)

slot8 = client.factory.create('ns0:Slot')
slot8.Time = 'PT18H30M'
slot8.Length = 30
slot8.Capacity = 5
slot8.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot8)

slot9 = client.factory.create('ns0:Slot')
slot9.Time = 'PT19H'
slot9.Length = 30
slot9.Capacity = 5
slot9.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot9)

slot10 = client.factory.create('ns0:Slot')
slot10.Time = 'PT19H30M'
slot10.Length = 30
slot10.Capacity = 5
slot10.AppointmentType = resource2.Section.AppointmentTypes.AppointmentType[0]
slots.Slot.append(slot10)
resource2.SchedulingPolicies.SchedulingPolicy[0].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

schPolicy.DayOfWeek = '2'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource2.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource2.SchedulingPolicies.SchedulingPolicy[1].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

schPolicy.DayOfWeek = '3'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource2.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource2.SchedulingPolicies.SchedulingPolicy[2].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

schPolicy.DayOfWeek = '4'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource2.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource2.SchedulingPolicies.SchedulingPolicy[3].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)

schPolicy.DayOfWeek = '5'
schPolicy.EndEffectDate = '2014-01-15'
schPolicy.StartEffectDate = '2013-01-04'
resource2.SchedulingPolicies.SchedulingPolicy.append(schPolicy)
resource2.SchedulingPolicies.SchedulingPolicy[4].Slots = slots
result = client.service.UpdateResource(resource2)
resource2 = copy.deepcopy(result)


appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource1

appointment.Patient = patient1
appointment.Length = 30
appointment.Section = resource1.Section
appTimeStamp = datetime.datetime.strptime('2013-08-08 19:00:00', '%Y-%m-%d %H:%M:%S')#datetime.datetime(2013,12,16,16,00,00) #datetime.datetime.utcnow()
appointment.Time = appTimeStamp
appointment.Resources = resourcearray
appointment.AppointmentType=resource1.Section.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment)
    appointment1 = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment1.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

appointment = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource2

appointment.Patient = patient1
appointment.Length = 30
appointment.Section = resource2.Section
appTimeStamp = datetime.datetime.strptime('2013-08-08 19:30:00', '%Y-%m-%d %H:%M:%S')#datetime.datetime(2013,12,16,16,00,00) #datetime.datetime.utcnow()
appointment.Time = appTimeStamp
appointment.Resources = resourcearray
appointment.AppointmentType=resource2.Section.AppointmentTypes.AppointmentType[0]
appointment.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment)
    appointment2 = copy.deepcopy(result)
    print 'current appointment status:  ' + appointment2.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

print 'step 3'
print '\tcheckin appointment to section one'
result = client.service.CheckInAppointment(appointment1.Id)
appointment1 = copy.deepcopy(result)

print 'step 4'
print 'display patient checkin status'
print appointment1.Status

print 'checkpoint 1'
if logdetail == 1:
	print appointment1
print '\tverified patinet checkin status'

print 'step 5'
print '\tdisplay patient checkin status on section two'
result = client.service.CheckInAppointment(appointment2.Id)
appointment2 = copy.deepcopy(result)
print appointment2.Status

print 'checkpoint 2'
if logdetail == 1:
	print appointment2
print '\tverified patinet checkin status on section two'

print 'step 6'
print '\tcheck-out the appointments'
try:
    result = client.service.CheckOutAppointment(appointment1.Id, 'Appointment Kept')
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

try:
    result = client.service.CheckOutAppointment(appointment2.Id, 'No Show')
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

print 'step 7'
print '\tdisplay other appointments for the patient'
print client.service.GetAppointmentsForPatient(patient1.Id,datetime.datetime(2013,01,04,00,00,00),datetime.datetime(2013,01,06,00,00,00))

print 'checkpoint 3'
if logdetail == 1:
	print appointment1
	print appointment2
print '\tverified patient appointment status'

print 'step 8'
print 'repeat step 1-7 for group appointment'
patients = client.service.SearchPatients(facility1_site_id,patient2_ssn)
patient2 = copy.deepcopy(client.service.GetPatient(patients[0]))

patients = client.service.SearchPatients(facility1_site_id,patient3_ssn)
patient3 = copy.deepcopy(client.service.GetPatient(patients[0]))

appointment3 = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource1

appointment3.Patient = patient2
appointment3.Length = 30
appointment3.Section = resource1.Section
appTimeStamp = datetime.datetime(2013,11,19,21,30,00)
appointment3.Time = appTimeStamp
appointment3.Resources = resourcearray
appointment3.AppointmentType=resource1.Section.AppointmentTypes.AppointmentType[0]
appointment3.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment3)
    appointment3 = copy.deepcopy(result)
    appointment3_id = copy.deepcopy(result.Id)
    print 'current appointment status:  ' + appointment3.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

appointment4 = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource1
appointment4.Patient = patient3
appointment4.Length = 30
appointment4.Section = resource1.Section
appTimeStamp = datetime.datetime(2013,11,19,21,30,00)
appointment4.Time = appTimeStamp
appointment4.Resources = resourcearray
appointment4.AppointmentType=resource1.Section.AppointmentTypes.AppointmentType[0]
appointment4.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment4)
    appointment4 = copy.deepcopy(result)
    appointment4_id = copy.deepcopy(result.Id)
    print 'current appointment status:  ' + appointment4.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

appointment5 = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource2

appointment5.Patient = patient2
appointment5.Length = 30
appointment5.Section = resource2.Section
appTimeStamp = datetime.datetime(2013,11,19,22,30,00)
appointment5.Time = appTimeStamp
appointment5.Resources = resourcearray
appointment5.AppointmentType=resource2.Section.AppointmentTypes.AppointmentType[0]
appointment5.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment5)
    appointment5 = copy.deepcopy(result)
    appointment5_id = copy.deepcopy(result.Id)
    print 'current appointment status:  ' + appointment5.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

appointment6 = client.factory.create('ns0:Appointment')
resourcearray = client.factory.create('ns0:ArrayOfResource')
resourcearray.Resource=resource2
appointment6.Patient = patient3
appointment6.Length = 30
appointment6.Section = resource2.Section
appTimeStamp = datetime.datetime(2013,11,19,22,30,00)
appointment6.Time = appTimeStamp
appointment6.Resources = resourcearray
appointment6.AppointmentType=resource2.Section.AppointmentTypes.AppointmentType[0]
appointment6.Status='Unknown'
try:
    result = client.service.CreateAppointment(appointment6)
    appointment6 = copy.deepcopy(result)
    appointment6_id = copy.deepcopy(result.Id)
    print 'current appointment status:  ' + appointment6.Status
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

sleep(10)
result = client.service.CheckInAppointment(appointment3_id)
sleep(5)
result = client.service.CheckInAppointment(appointment4_id)
sleep(5)
result = client.service.CheckInAppointment(appointment5_id)
sleep(5)
result = client.service.CheckInAppointment(appointment6_id)
sleep(10)
try:
    result = client.service.CheckOutAppointment(appointment3_id, 'Left without being seen')
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()
sleep(10)
try:
    result = client.service.CheckOutAppointment(appointment4_id, 'No Show')
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()
sleep(10)
try:
    result = client.service.CheckOutAppointment(appointment5_id, 'Appointment Kept')
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()
sleep(10)
try:
    result = client.service.CheckOutAppointment(appointment6_id, 'No Show')
except Exception, e:
    print 'error:  '
    print e
    sys.exc_clear()

print 'checkpoint 4'
if logdetail == 1:
	print appointment3
	print appointment4
	print appointment5
	print appointment6
print '\tverified checkout status on group appointment'